﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;

namespace PI.ZB.N1200.ELearning.WebApplication.Statistics
{
    public partial class Instructor : StatsBaseComponent
    {
        protected class StudentCompetencePartPanel : StatsPanel
        {
            public StudentCompetencePartPanel(StatsBaseComponent Component) : base(Component) { }

            public override void Load()
            {
                if (!StudentID.HasValue)
                {
                    return;
                }
                BL.BO.Student _student = Component.BLELearning.Student.Restore(StudentID);
                if (_student == null)
                {
                    return;
                }

                if (CompetenceID.HasValue)
                {
                    Component.AppendToXML(_student);

                    List<BL.BO.Student> _listStudent = new List<BL.BO.Student>();
                    _listStudent.Add(_student);
                    AppendToXML(_listStudent);

                    // tutaj statystyka dla danej kompetencji glownej, wiec lista zawiera tylko jeden wpis
                    AppendToXML(_student, Component.BLELearning.Statistic.CompetenceStatistic.Restore(_student, CompetenceID));

                    // tutaj lista kompetencji skladowych posumowana dla danej kompetencji glownej wkontekscie studenta
                    // stopnie trudnosci tez sa rozbijane, ale w sumie nie trzeba pokazywac rozbicia na poziomie kompetencji skladowej w kontekscie studenta
                    // tutaj jeszcze chwila zastanowienia
                    AppendToXML(_student, Component.BLELearning.Statistic.CompetencePartStatistic.Restore(_student, CompetenceID));

                    // Lista stopni zaawansowania
                    AppendToXML(Component.BLELearning.AdvancedLevel.Restore());

                    // Lista ocen
                    AppendToXML(Component.BLELearning.EvaluationSheet.Restore());
                }
            }

            public override bool Save()
            {
                return true;
            }
        }
    }
}